%Note that the scripts in the Dependencies folder are required to run the
%script
clear
close all
fig_dir='C:\Users\engelsen\Documents\MATLAB\Hero sample strobe data\Figures\';
load('metadata_strobe.mat');
ref=load('ref_data.mat');
fig_no=10;
x_min=0;
x_max=max(cellfun(@(x) max(x),x_mean));
x_vec=linspace(x_min,x_max,1e4);
ax_size=4.4;
fig=figure(fig_no);

%Remove first plot, as it is plotted above in the SI anyway
y_mean=y_mean(2:end);
x_mean=x_mean(2:end);
comb_ind=comb_ind(2:end);

for i=1:length(y_mean)
    subplot(3,3,i);

    ax(i)=gca;
    %Plots the continuous measurement
    ref_line=plot(ref.x_mean,ref.y_mean,'Color',[rgb('red'),0.3]);

    hold on
    %Colors data differently if it is below a threshold or not in the strobe
    new_ind=y_mean{i}<0.07 & ~comb_ind{i};
    h_strobe=plot(x_mean{i}(~new_ind),y_mean{i}(~new_ind),...
        'Color',rgb('red'),'Marker','.',...
        'LineStyle','none','MarkerSize',2);

    h_bg=plot(x_mean{i}(new_ind),y_mean{i}(new_ind),...
        'Color',rgb('light gray'),...
        'LineStyle','none',...
        'Marker','.',...
        'MarkerSize',2);
    plot(x_vec,fitdatas{i}(x_vec),'Color','k','LineStyle',':')
    set(ax(i),'YScale','Log');
    
    %Draws the Y-tick labels only if the plot is on the bottom
    if ~any(i==[1,4,7])
       set(gca,'YTickLabel',[]);
    else
        set(gca,'YTick',[1e-1,1]);
        ylabel('Amp. (norm)')
    end
    
    %Draws the X-tick labels only if the plot is on the side
    if ~any(i==[4,5,6])
        set(gca,'XTickLabel',[]);
    else
        set(gca,'XTick',[0,200,400]);
        xlabel('Time (s)')
    end
    
    axis square
    box on
    axis([0,420,0.007,1.2]);
end
set(fig,'Color','w')



%Resizes and positions the plots to have a tighter packing
for i=1:length(ax)
    ax(i).Units='centimeters';
    ax(i).Position=[2+5*mod(i-1,3),2+5*floor((length(ax)-i)/3),ax_size,ax_size];
    ax(i).LineWidth=1;
end

makePDF_klab(fig_no,sprintf('Strobe%d',i),18,12,fig_dir)
